/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.conwip;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cz.insophy.inplan.planning.mokos.conwip.ConwipOperationLog;
import cz.insophy.inplan.planning.mokos.conwip.GorWrapper;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConwipIslandLog {
    private final String islandName;
    private final long normtimeAvailable;
    private Map<GorWrapper.GarWrapper, ConwipOperationLog> opLogs;
    private boolean blocking;

    protected ConwipIslandLog(String islandName, long normtimeAvailable) {
        this.islandName = islandName;
        this.normtimeAvailable = normtimeAvailable;
        this.opLogs = Maps.newLinkedHashMap();
        this.blocking = false;
    }

    protected void logAllocation(@Nonnull GorWrapper.GarWrapper gaw, long t) {
        ConwipOperationLog opLog = new ConwipOperationLog(gaw.getParent().getGor().getId(), gaw.getGar().getAction().getName(), gaw.getRequestedNormtime(), gaw.getParent().getOrder(), t);
        ConwipOperationLog old = this.opLogs.put(gaw, opLog);
        Preconditions.checkState(old == null, "Allocation of %s was already logged.", (Object)gaw);
    }

    protected void logDeallocation(@Nonnull GorWrapper.GarWrapper gaw, long t) {
        ConwipOperationLog opLog = this.opLogs.get(gaw);
        Preconditions.checkState(opLog != null, "Allocation of %s was not logged before deallocation.", (Object)gaw);
        opLog.setDeallocT(t);
    }

    protected void logBlock() {
        this.blocking = true;
    }

    public Collection<ConwipOperationLog> getOperations() {
        return this.opLogs.values();
    }

    public long getNtAvailable() {
        return this.normtimeAvailable;
    }

    public String getIslandName() {
        return this.islandName;
    }

    public boolean isBlocking() {
        return this.blocking;
    }
}

